# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 6
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR6_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR6(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Round 1: Cooperate
    if current_round == 1:
        return "C"
    
    # Check for unconditional strategies in opponent's code
    if "always D" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    if "always C" in opponent_program_code or "return 'C'" in opponent_program_code:
        if current_round >= total_rounds - 2:
            return "D"
        else:
            return "C"
    
    # Early Rounds (2-3): Tit-for-Tat
    if current_round <= 3:
        return opp_history[-1]
    
    # Middle Rounds (4-7)
    if current_round <= 7:
        coop_count = opp_history.count("C")
        defect_count = opp_history.count("D")
        if coop_count >= defect_count:
            return opp_history[-1]  # Tit-for-Tat
        else:
            # Tit-for-Two-Tats
            if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
                return "D"
            else:
                return "C"
    
    # Late Rounds (8-10)
    # Check if opponent is Tit-for-Tat
    if "opp_history[-1]" in opponent_program_code and "return opp_history[-1]" in opponent_program_code:
        # Alternate between C and D to confuse Tit-for-Tat
        if current_round % 2 == 0:
            return "D"
        else:
            return "C"
    else:
        # Default: defect in last 2 rounds
        if current_round >= total_rounds - 1:
            return "D"
        else:
            return opp_history[-1]